#include <iostream>
#include <fstream>
#include <cstdio>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;

typedef long long ll;

struct Vertex {
    int letter[5]={};
    int from[5]={-1, -1, -1, -1, -1};
};

int n, m;
string s;

vector<Vertex> tree;
void build(int l, int r, int ind) {
    if (l == r) {
        tree[ind].letter[int(s[l]) - int('a')] = 1;
    }
    else {
        int m = (l + r) / 2;
        build(l,   m, 2*ind + 1);
        build(m+1, r, 2*ind + 2);
        for (int i = 0; i < 5; i++)
            tree[ind].letter[i] = tree[2*ind + 1].letter[i] + tree[2*ind + 2].letter[i];
    }
}
Vertex sum(int s, int f,   int l, int r, int ind) {
    if (s == l && f == r)
        return tree[ind];
    int m = (l + r) / 2;
    if (f <= m)
        return sum(s, f,   l,   m, 2*ind + 1);
    else if (m+1 <= s)
        return sum(s, f,   m+1, r, 2*ind + 2);
    else {
        Vertex a = sum(s,   m,   l,   m, 2*ind + 1);
        Vertex b = sum(m+1, f,   m+1, r, 2*ind + 2);
        Vertex res;
        for (int i = 0; i < 5; i++)
            res.letter[i] = a.letter[i] + b.letter[i];
        return res;
    }
}
void modify(int s, int f, int v, int u,   int l, int r, int ind) {
    if (l == r) {
        tree[ind].letter[u] += tree[ind].letter[v];
        tree[ind].letter[v] = 0;
    }
    else {
        int m = (l + r) / 2;
        if (f <= m)
            modify(s, f, v, u,   l,   m, 2*ind + 1);
        else if (m+1 <= s)
            modify(s, f, v, u,   m+1, r, 2*ind + 2);
        else {
            modify(s,   m, v, u,   l,   m, 2*ind + 1);
            modify(m+1, f, v, u,   m+1, r, 2*ind + 2);
        }
        for (int i = 0; i < 5; i++)
            tree[ind].letter[i] = tree[2*ind + 1].letter[i] + tree[2*ind + 2].letter[i];
    }
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    //freopen("inE.txt", "r", stdin);

    cin >> n >> m;
    cin >> s;

    tree.resize(4*n);
    build(0, n-1, 0);

    while (m--) {
        int x;
        char a, b;
        cin >> x >> a >> b;
        int v = int(a) - int('a');
        int u = int(b) - int('a');

        int l = -1, r = n-1, y;
        while (r - l > 1) {
            y = (l + r) / 2;
            if (sum(0, y,   0, n-1, 0).letter[v] >= x)
                r = y;
            else
                l = y;
        }
        modify(0, r, v, u,   0, n-1, 0);
    }

    for (int i = 0; i < n; i++) {
        Vertex p = sum(i, i,   0, n-1, 0);
        for (int j = 0; j < 5; j++) {
            if (p.letter[j] > 0) {
                cout << char(int('a') + j);
                break;
            }
        }
    }

    return 0;
}